<?php

/**
 * FrmjQAutocomHooksController class.
 */
class FrmjQAutocomHooksController{

	/**
	 * load_hooks function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function load_hooks() {

    	add_action( 'plugins_loaded', 'FrmjQAutocomAppController::load_lang' );

		add_filter( 'wp_head', 'FrmjQAutocomAppController::register_scripts' );

        add_action( 'wp_footer', 'FrmjQAutocomAppController::footer_js', 20 );

		add_filter( 'frm_setup_new_fields_vars', 'FrmjQAutocomAppController::setup_jqautocom_fields', 20, 2 );
		add_filter( 'frm_setup_edit_fields_vars', 'FrmjQAutocomAppController::setup_jqautocom_fields', 20, 2 );
        add_action( 'frm_form_fields', 'FrmjQAutocomAppController::front_field', 10, 2 );

		add_filter( 'frm_validate_field_entry', 'FrmjQAutocomAppController::validate', 9, 3 );

		self::load_admin_hooks();
	}

	/**
	 * load_admin_hooks function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function load_admin_hooks() {
		if ( ! is_admin() ) {
			return;
		}

		add_action( 'admin_init', 'FrmjQAutocomAppController::admin_init' );

		// add_action( 'admin_init', 'FrmjQAutocomAppController::include_updater', 1 );
		add_filter( 'frm_switch_field_types', 'FrmjQAutocomAppController::jqautocom_types', 10, 2);
		add_filter( 'frm_display_field_options', 'FrmjQAutocomAppController::jqautocom_display_options');

		add_action( 'admin_footer', 'FrmjQAutocomAppController::footer_js', 20 );

        add_action( 'wp_ajax_jqautocom_add_field_option', 'FrmjQAutocomAppController::add_option' );
		add_action( 'wp_ajax_jqautocom_import_choices', 'FrmjQAutocomAppController::jqautocom_import_choices' );
        add_action( 'wp_ajax_jqautocom_import_options', 'FrmjQAutocomAppController::jqautocom_import_options' );

		add_filter( 'frm_pro_available_fields', 'FrmjQAutocomAppController::maybe_add_field', 7 );
		add_filter( 'frm_before_field_created', 'FrmjQAutocomAppController::set_defaults' );

		add_action( 'frm_display_added_fields', 'FrmjQAutocomAppController::admin_field' );
		add_action( 'frm_before_field_options', 'FrmjQAutocomAppController::options_form_before', 10, 1);
		add_action( 'frm_field_options_form', 'FrmjQAutocomAppController::options_form', 10, 3 );

		// Styles Controller
		add_action( 'frm_include_front_css', 'FrmjQAutocomAppController::include_front_css' );
	}
}