function jQAutocomAdminBuildJS(){
    var $newjqFields = jQuery(document.getElementById('new_fields')),
	    this_form_id = jQuery(document.getElementById('form_id')).val(),
        cancelSort = false;

    function empty($obj){
		if ( $obj !== null ) {
			while ( $obj.firstChild ) {
				$obj.removeChild($obj.firstChild);
			}
		}
	}

	function addClass($obj, className){
		if ($obj.classList){
			$obj.classList.add(className);
		}else{
			$obj.className += ' ' + className;
		}
	}

    function jqautocom_addFieldOption() {

        var field_id = jQuery(this).closest('li').data('fid'),
            opt_type = jQuery(this).data('opttype'),
    	 	opt_key = 1,
            lastOpt = jQuery('#frm_field_'+ field_id +'_opts li:last');

    	if(lastOpt.length){
    		opt_key = lastOpt.attr('id').replace('frm_delete_field_'+ field_id +'-', '').replace('_container', '').replace('other_', '');
    		opt_key = parseInt(opt_key) + 1;
    	}

        //Update hidden field
        if ( opt_type == 'other' ) {
            document.getElementById('other_input_' + field_id).value = 1;

            //Hide "Add Other" option now
            jQuery(this).fadeOut('slow');
        }

    	var data = {
    		action:'jqautocom_add_field_option', field_id:field_id,
    		opt_key:opt_key,
    		opt_type:opt_type, nonce:frmGlobal.nonce
    	};

        jQuery.post(ajaxurl,data,function(msg){
            jQuery(document.getElementById('frm_field_'+field_id+'_opts')).append(msg);
    		resetjQAutocomOpts(field_id);
        });
    }

    function resetjQAutocomOpts(id){
		var field = document.getElementById('frm_jquautocom_'+id);
		if ( field !== null ) {
			filljQAutocomOpts(field, id);
		}
	}

    function filljQAutocomOpts(field, sourceID, includeBlank){
		if ( field !== null ) {
			removejQAutocomOpts(field);
			var opts = jQuery('input[name^="field_options[options_'+sourceID+'"][name$="[value]"]');
			var l = opts.length;
			jQuery.each(opts, function() {
				var labelName = this.name.replace('[value]', '[label]');
				var value = this.value;
				if ( includeBlank == 'blank' && value !== '' ) {
				    var blankOpt = document.createElement('option');
				    blankOpt.value = '';
				    field.appendChild(blankOpt);
					includeBlank = false;
				}

			    var opt = document.createElement('option');
			    opt.value = value;
			    opt.innerHTML = jQuery('input[name="'+labelName+'"]').val();
			    field.appendChild(opt);
			});
		}
	}

    function removejQAutocomOpts(field){
	    var i;
	    for(i = field.options.length - 1 ; i >= 0 ; i--){
	        field.remove(i);
	    }
	}

    function setjQAutocomIPEOpts(){
		var id = jQuery(this).attr('id'),
		    fieldId = jQuery(this).closest('.frm_field_box').data('fid');
		jQuery(this).editInPlace({
			default_text:frm_admin_js.blank,
			callback:function(d,text){
				var input = jQuery(this).next('input');
				input.val(text);
				var new_text = text || frm_admin_js.blank;
				checkUniqueOpt(id,text);
				maybeSetSavedVal(id, fieldId, text, input);
				return new_text;
			},
			postclose:function(){
				resetjQAutocomOpts(fieldId);
			}
		});
	}

	return {

    	jqInit: function() {

        	if($newjqFields.length > 0){
				// only load this on the form builder page
				jQAutocomAdminBuild.jqBuildInit();
			}
    	},

    	jqBuildInit: function() {
            $newjqFields.on('click', '.jqautocom_add_opt', jqautocom_addFieldOption);
            $newjqFields.on('mouseenter', '.frm_jqautocom_ipe_field_option, .frm_jqautocom_ipe_field_option_key', setjQAutocomIPEOpts);
    	},

        jqUpdateOpts: function(field_id,opts){
			$fieldOpts = document.getElementById('frm_field_'+field_id+'_opts');
			empty($fieldOpts);
			addClass($fieldOpts, 'frm-loading-img');
			jQuery.ajax({
				type:"POST",url:ajaxurl,
				data:{action:'jqautocom_import_options', field_id:field_id, opts:opts, nonce:frmGlobal.nonce},
				success:function(html){
                    jQuery('#frm_field_'+field_id+'_opts').html(html).removeClass('frm-loading-img');
                        if(jQuery('select[name="item_meta['+field_id+']"]').length>0){
        					var o = opts.replace(/\s\s*$/,'').split("\n");
        					var sel='';
        					for (var i=0;i<o.length;i++){
        						sel +='<option value="'+o[i]+'">'+o[i]+'</option>';
        				}
    					jQuery('select[name="item_meta['+field_id+']"]').html(sel);
    				}
				}
			});
		},
	};
}

var jQAutocomAdminBuild = jQAutocomAdminBuildJS();

jQuery(document).ready(function ($) {
    jQAutocomAdminBuild.jqInit();
});