<?php
$display = apply_filters('frm_display_field_options', array(
    'type' => $field['type'], 'field_data' => $field,
    'required' => true, 'unique' => false, 'read_only' => false,
    'description' => true, 'options' => true, 'label_position' => true,
    'invalid' => false, 'size' => false, 'clear_on_focus' => false,
    'default_blank' => true, 'css' => true, 'conf_field' => false,
	'max' => true, 'captcha_size' => false,
));
$field['options']
?>
<div class="frm_form_fields" data-ftype="<?php echo esc_attr( $display['type'] ) ?>">
<?php
    $read_only = false;
    if ( isset($field['post_field']) && $field['post_field'] == 'post_category' ) {
		echo FrmFieldsHelper::dropdown_categories( array( 'name' => $field_name, 'field' => $field ) );
    } else {  ?>
	<select id="frm_jquautocom_<?php echo esc_attr( $field['id'] ) ?>" name="<?php echo esc_attr( $field_name ) . ( FrmField::is_option_true( $field, 'multiple' ) ? '[]' : '' ); ?>" <?php
		echo FrmField::is_option_true( $field, 'size' ) ? 'class="auto_width"' : '';
		echo FrmField::is_option_true( $field, 'multiple' ) ? ' multiple="multiple"' : ''; ?> >
		<?php
        $other_opt = false;
        $other_checked = false;
	    foreach ( $field['options'] as $opt_key => $opt ) {
            $field_val = apply_filters('frm_field_value_saved', $opt, $opt_key, $field);
            $opt = apply_filters('frm_field_label_seen', $opt, $opt_key, $field);
			$selected = ( $field['default_value'] == $field_val || FrmFieldsHelper::get_other_val( array( 'opt_key', 'field' ) ) ) ? ' selected="selected"' : ''; ?>
            <option value="<?php echo esc_attr( $field_val ) ?>"<?php echo $selected ?>><?php echo esc_html( $opt ) ?> </option>
        <?php } ?>
    </select>
<?php
        if ( $other_opt === false ) {
    		$other_args = FrmFieldsHelper::prepare_other_input( compact( 'field', 'field_name', 'opt_key' ), $other_opt, $selected );
    		if ( FrmFieldsHelper::is_other_opt( $opt_key ) && $selected ) {
    			$other_checked = true;
    		}
    	}
        FrmFieldsHelper::include_other_input( array(
    		'other_opt' => $other_opt, 'read_only' => $read_only,
    		'checked' => $other_checked, 'name' => $other_args['name'],
    		'value' => $other_args['value'], 'field' => $field,
    		'html_id' => $html_id, 'opt_key' => false,
    	));
	}

    if ( $display['default_blank'] ) { ?>
        <span id="frm_clear_on_focus_<?php echo esc_attr( $field['id'] ) ?>" class="frm_clear_on_focus frm-show-click">
		<?php FrmFieldsHelper::show_default_blank_js( $field['default_blank'] ); ?>
        </span>
		<input type="hidden" name="field_options[default_blank_<?php echo esc_attr( $field['id'] ) ?>]" value="<?php echo esc_attr( $field['default_blank'] ) ?>" />
    <?php } ?>
    <div class="clear"></div>
    <div class="frm-show-click frm_small_top_margin">
    <?php
	if ( ! isset( $field['post_field'] ) || ! in_array( $field['post_field'], array( 'post_category' ) ) ) { ?>
        <?php do_action('frm_add_multiple_opts_labels', $field); ?>
        <ul id="frm_field_<?php echo esc_attr( $field['id'] ) ?>_opts" class="frm_sortable_field_opts<?php echo ( count($field['options']) > 10 ) ? ' frm_field_opts_list' : ''; ?>">
        <?php FrmjQAutocomAppController::show_jqautocom_options($field); ?>
        </ul>
<?php
    } ?>
    </div>
<?php
if ( $display['clear_on_focus'] ) {
	FrmFieldsHelper::clear_on_focus_html( $field, $display );
	do_action( 'frm_extra_field_display_options', $field );
}
?>
<div class="clear"></div>
</div>

<div class="frm-show-click frm_small_top_margin"><?php

if ( isset($field['post_field']) && $field['post_field'] == 'post_category' ) {
	echo '<p class="howto">' . FrmFieldsHelper::get_term_link( $field['taxonomy'] ) . '</p>';
} else if ( ! isset( $field['post_field'] ) || ! in_array( $field['post_field'], array( 'post_category' ) ) ) {
?>
    <div id="frm_add_field_<?php echo esc_attr( $field['id'] ); ?>">
        <a href="javascript:void(0);" data-opttype="single" class="button frm_cb_button jqautocom_add_opt"><?php _e( 'Add Option', 'formidable' ) ?></a>

        <?php
		if ( FrmAppHelper::pro_is_installed() ) { ?>
			<a href="javascript:void(0);" id="other_button_<?php echo esc_attr( $field['id'] ); ?>" data-opttype="other" data-ftype="<?php echo esc_attr( $field['type'] ) ?>" class="button frm_cb_button jqautocom_add_opt<?php echo ($field['other'] == true ? ' frm_hidden' : '' ); ?>"><?php _e( 'Add "Other"', 'formidable' ) ?></a>
            <input type="hidden" value="<?php echo esc_attr( $field['other'] ); ?>" id="other_input_<?php echo esc_attr( $field['id'] ); ?>" name="field_options[other_<?php echo esc_attr( $field['id'] ); ?>]">
        <?php
        }

        if ( ! isset($field['post_field']) || $field['post_field'] != 'post_category' ) { ?>
		<a href="<?php echo esc_url( admin_url( 'admin-ajax.php?action=jqautocom_import_choices&field_id=' . $field['id'] . '&TB_iframe=1' ) ) ?>" title="<?php echo esc_attr( FrmAppHelper::truncate( strip_tags( str_replace( '"', '&quot;', $field['name'] ) ), 20 ) . ' ' . __( 'Field Choices', 'formidable' ) ); ?>" class="thickbox frm_orange">
			<?php _e( 'Bulk Edit Options', 'formidable' ) ?>
		</a>
        <?php } ?>
    </div>
<?php
}
?>
</div>