<?php

/**
 * FrmjQAutocomAppController class.
 */
class FrmjQAutocomAppController {

	/**
	 * load_lang function.
	 *
	 * loads the plugin's text domain
	 *
	 * called from FrmjQAutocomHooksController::load_hooks()
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function load_lang() {
		$plugin_folder = FrmjQAutocomAppHelper::plugin_folder();
		load_plugin_textdomain( 'frmjqautocom', false, $plugin_folder . '/languages/' );
	}

    public static function admin_init() {
		$version = FrmjQAutocomAppHelper::plugin_version();
		self::register_scripts();
		FrmjQAutocomAppHelper::load_jqautocom_admin_wide_js( false );

		$page = FrmAppHelper::simple_get( 'page', 'sanitize_title' );
		$post_type = FrmAppHelper::simple_get( 'post_type', 'sanitize_title' );

		global $pagenow;

		if ( strpos( $page, 'formidable' ) === 0 || ( $pagenow == 'edit.php' && $post_type == 'frm_display' ) ) {

            wp_enqueue_script( 'frm-jqautocom' );

        } else if ( $pagenow == 'post.php' || ( $pagenow == 'post-new.php' && $post_type == 'frm_display' ) ) {

            if ( $post_type == 'frm_display' ) {

                wp_enqueue_script( 'frm-jqautocom' );
            }
        }
    }
    	/**
	 * register_scripts function.
	 *
	 * called from FrmjQAutocomHooksController::load_hooks()
	 *
	 * @access public
	 * @static
	 * @param array $form
	 * @return $form
	 *
	 * applies jqautocom_custom_css filter to allow for user defined css files.
	 */
	public static function register_scripts() {

		$url = FrmjQAutocomAppHelper::plugin_url();

		$css_file_to_load = apply_filters('jqautocom_custom_css', $url . '/css/jquery.frm-jqautocom.css' );

        wp_register_script( 'frm-jqautocom', $url .'/js/jqautocom_admin.js', array('jquery'), "", true );
        wp_register_style( 'jquery-frm-jqautocom', $css_file_to_load );

		add_filter( 'frm_ajax_load_scripts', 'FrmjQAutocomAppController::ajax_load_scripts' );
		add_filter( 'frm_ajax_load_styles', 'FrmjQAutocomAppController::ajax_load_styles' );

    }

    /**
     * enqueue_scripts function.
     *
     * called from self::front_field
     *
     * load front end static scripts/styles here
     *
     * @access public
     * @static
     * @return void
     */
    public static function enqueue_scripts() {

        // if the version delivered with wordpress is loaded, use it.
        // if ( wp_script_is( 'jquery-ui-autocomplete', 'registered' ) ) {
        wp_enqueue_script( 'jquery-ui-autocomplete' );

        /* the next two are required for the combo box */
		wp_enqueue_script( 'jquery-ui-tooltip' );
		wp_enqueue_script( 'jquery-ui-button' );

		/* need formidable's jQuery scripts */
		FrmStylesHelper::enqueue_jquery_css();

		/* finally, load the plugin's custom styles */
		wp_enqueue_style( 'jquery-frm-jqautocom' );

	}

	/**
	 * ajax_load_scripts function.
	 *
	 * called from self::register_scripts
	 *
	 * @access public
	 * @static
	 * @param array $scripts
	 * @return $scripts
	 *
	 * Make sure these scripts are loaded on ajax page change if enqueued
	 */
	public static function ajax_load_scripts( $scripts ) {

		$scripts = array_merge( $scripts, array( 'frm-jqautocom' ) );
		return $scripts;
	}

	/**
	 * ajax_load_styles function.
	 *
	 * called from self::register_scripts
	 *
	 * @access public
	 * @static
	 * @param array $styles
	 * @return $styles
	 *
	 * Make sure these styles are loaded on ajax page change if enqueued
	 */
	public static function ajax_load_styles( $styles ) {
		$styles[] = 'jquery-frm-jqautocom';
		return $styles;
	}

	/**
	 * maybe_add_field function.
	 *
	 * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
	 * @access public
	 * @static
	 * @param array $fields
	 * @return $fields
	 */
	public static function maybe_add_field( $fields ) {
		if ( method_exists( 'FrmAppHelper', 'pro_is_installed' ) && FrmAppHelper::pro_is_installed() ) {
    		add_filter( 'frm_pro_available_fields', 'FrmjQAutocomAppController::add_field' );
			// $fields = self::add_field( $fields );
        } else {
            $fields = self::add_field( $fields );
		}
		return $fields;
	}

    /**
     * add_field function.
     *
     * called from self::maybe_add_field
	 *
     * @access public
     * @static
     * @param array $fields
     * @return $fields
     */
    public static function add_field( $fields ) {
        $fields['jqautocom'] = __( 'jQuery Autocomp', 'frmjqautocom' );
        return $fields;
    }

    /**
     * set_defaults function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $field_data
     * @return $field_data
     */
    public static function set_defaults( $field_data ) {
        if ( self::array_find( 'jqautocom', $field_data ) ) {
            $name = __( 'jQuery Autocomp' , 'frmjqautocom' );
            $field_data['name'] = $name;
            $field_data['options'] = serialize( array( "0" => "", "1" => "Option 1") );
            $width = FrmStylesController::get_style_val( 'auto_width', $field_data['form_id'] );
            $field_data['field_options']['size'] = $width;
            foreach ( self::get_defaults() as $k => $v ) {
                if (gettype($v) == 'array') {
                    foreach ($v as $k2 => $v2) {
                        $field_data['field_options'][ $k ][$k2] = $v2;
                    }
                } else {
                    $field_data['field_options'][ $k ] = $v;
                }
            }
        }
        return $field_data;
    }

    /**
     * array_find function.
     *
     * used only in self::jqautocom_types,
     *              self::jqautocom_display_options,
     *              self::admin_field,
     *              self::options_form_before,
     *              self::options_form,
     *              self::front_field,
     *              self::set_defaults
     *
     * @access public
     * @static
     * @param string $needle
     * @param array $haystack
     * @return boolean
     */
    public static function array_find( $needle, array $haystack ) {

        foreach ($haystack as $key => $value) {

            if ( gettype($value) == 'string' && false !== stripos($value, $needle) ) {
                return true;
            }
        }
        return false;
    }

    /**
     * jqautocom_types function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $field_types
     * @param array $type
     * @return $field_types
     */
    public static function jqautocom_types( $field_types, $type ) {
        if( self::array_find( 'jqautocom', $type ) ){
            $field_types = array(
                "jqautocom"                 => "Default",
                "jqautocom-combo"           => "ComboBox",
            );

            /* all autocomplete type:
            $field_types = array(
                "jqautocom"                 => "Default",
                "jqautocom-accent"          => "Accent Folding",
                "jqautocom-categories"      => "Categories",
                "jqautocom-combo"           => "ComboBox",
                "jqautocom-custom"          => "Custom Data &amp; Display",
                "jqautocom-multi"           => "Multiple Values",
                "jqautocom-multi-remote"    => "Multiple, remote",
                "jqautocom-remote"          => "Remote datasource",
                "jqautocom-jsonp"           => "Remote JSONP datasource",
                "jqautocom-remote-cache"    => "Remote with caching",
                "jqautocom-scroll"          => "Scrollable Results",
                "jqautocom-xml"             => "XML data parsed once",

            );
            */
        }
        return $field_types;
    }

    /**
     * get_defaults function.
     *
     * called from self::set_defaults
     *
     * @access public
     * @static
     * @return void
     */
    public static function get_defaults(){
        return array(
            'default_value'                 => "",
            'required'                      => 0,
            'unique'                        => 0,
            'read_only'                     => 0,
            'restrict'                      => 0,
            'invalid'                       => "Dropdown is invalid",
            'data_type'                     => "jqautocom",
            'autopopulate_value'            => false,
            'get_values_form'               => "",
            'get_values_field'              => "",
            'watch_lookup'                  => array(),
            'get_most_recent_value'         => "",
            'lookup_filter_current_user'    => false,
            'options'                       => serialize( array( "0" => "", "1" => "Option 1") ),
        );
    }

    /**
     * show_jqautocom_options function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * called in /views/admin_field.php
     * @access public
     * @static
     * @param array $field
     * @return void
     */
    public static function show_jqautocom_options( $field ) {
        $field_name = $field['name'];
        $html_id = FrmFieldsHelper::get_html_id($field);
        foreach ( $field['options'] as $opt_key => $opt ) {
            $field_val = apply_filters('frm_field_value_saved', $opt, $opt_key, $field);
            $opt = apply_filters('frm_field_label_seen', $opt, $opt_key, $field);

            require( FrmjQAutocomAppHelper::plugin_path() . '/views/single-option.php' );
        }
    }

    /**
     * jqautocom_display_options function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $display
     * @return $display
     */
    public static function jqautocom_display_options( $display ) {
        if ( self::array_find( 'jqautocom', $display ) ) {

            $display['required']        = true;
            $display['unique']          = true;
            $display['read_only']       = true;
            $display['description']     = true;
            $display['options']         = true;
            $display['label_position']  = true;
            $display['invalid']         = false;
            $display['size']            = false;
            $display['clear_on_focus']  = false;
            $display['default_blank']   = true;
            $display['css']             = true;
            $display['conf_field']      = false;
            $display['max']             = false;
            $display['captcha_size']    = false;

        }
        return $display;
    }

    /**
     * admin_field function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $field
     * @return void
     */
    public static function admin_field( $field ) {
        if ( ! self::array_find( 'jqautocom', $field ) ) {
            return;
        }
        $field_id = absint( $field['id'] );
        $field_name = 'item_meta[' . $field_id . ']';
        $html_id = FrmFieldsHelper::get_html_id($field);
        include( FrmjQAutocomAppHelper::plugin_path() .'/views/admin_field.php' );

    }

    /**
     * options_form_before function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $field
     * @return void
     */
    public static function options_form_before($field) {
        if ( ! self::array_find( 'jqautocom', $field ) ) {
            return;
        }
    }

    /**
     * options_form function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @param array $field
     * @param mixed $display
     * @param mixed $values
     * @return void
     */
    public static function options_form( $field, $display, $values ) {

        if ( ! self::array_find( 'jqautocom', $field ) ) {
            return;
        }

        foreach ( self::get_defaults() as $k => $v ) {
            if ( ! isset( $field[ $k ] ) ) {
                $field[ $k ] = $v;
            }
        }

        include( FrmjQAutocomAppHelper::plugin_path() .'/views/options_form.php' );
    }

	/**
	 * include_front_css function.
	 *
	 * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
	 * @access public
	 * @static
	 * @param array $args
	 * @return void
	 */
	public static function include_front_css( $args ) {
		$defaults = $args['defaults'];
		include( FrmjQAutocomAppHelper::plugin_path() . '/css/jqautocomplete.css.php' );
	}
    /**
     * If this form uses ajax, we need all the jQuery Autocomplete field info in advance
     */

    /**
     * setup_jqautocom_fields function.
     *
     * called from FrmjQAutocomHooksController::load_hooks()
	 *
     * @access public
     * @static
     * @param array $values
     * @param object $field
     * @param mixed $entry_id (default: false)
     * @return $values
     */
    public static function setup_jqautocom_fields ( $values, $field, $entry_id = false ) {
        if ( stripos($field->type, 'jqautocom') === false && ! isset( $field->field_options['label1'] ) ) {
            return $values;
        }

		// Make sure jqautocom value is formatted correctly
		self::check_jqautocom_value_format( $values['value'] );

		// If the jqautocom has already been saved, don't load scripts for this field
        if ( $entry_id && is_array( $values['value'] ) && self::isset_and_not_empty_in_array( $values['value'], 'output' ) ) {
            return $values;
        }

        global $frm_vars;
        if ( ! is_array( $frm_vars ) ) {
            $frm_vars = array();
        }

        if ( ! isset( $frm_vars['jqautocom_fields'] ) || empty( $frm_vars['jqautocom_fields'] ) ) {
            $frm_vars['jqautocom_fields'] = array();
        }

        $style_settings = self::get_style_settings( $field->form_id  );

        $jqautocom_opts = array(
            'id'            => $field->id,
            'width'         => $values['size'],
        );

		foreach ( array( 'bg_color', 'text_color', 'border_color' ) as $color ) {
			if ( ! empty( $style_settings[ $color ] ) ) {
				$jqautocom_opts[ $color ] = '#'. $style_settings[ $color ];
			}
		}

		$field_arr = (array) $field;
        $html_id = FrmFieldsHelper::get_html_id($field_arr);

		$frm_vars['jqautocom_fields'][] = $jqautocom_opts;
		$frm_vars['jqautocom_type'] = $field->type;
		$frm_vars['jqautocom_options'] = $values['options'];
		$frm_vars['html_id'] = $html_id;

        return $values;
    }

	/**
	 * Check if an item isset and is not empty in an array
	 *
	 * called from self::setup_jqautocom_fields
	 *
	 * @since 1.0.0
	 * @param array $array
	 * @param string $key
	 * @return boolean
	 */
	private static function isset_and_not_empty_in_array( $array, $key ) {
		return isset( $array[ $key ] ) && ! empty( $array[ $key ] );
	}

	/**
	 * Check the value for a jqautocom field. Make sure it is an array if the value is not empty.
	 *
	 * called from self::setup_jqautocom_fields
	 *
	 * @since 1.08
	 * @param array|string $value
	 * @return void
	 */
	private static function check_jqautocom_value_format( &$value ) {
		if ( $value ) {
			$value = maybe_unserialize( $value );

			if ( is_array( $value ) ) {
				// Make sure the 'output' jqautocom isn't saved as the 'typed' value
				if ( isset( $value['typed'] ) && strpos( $value['typed'], '[{"lx":' ) !== false ) {
					if ( ! isset( $value['output'] ) || empty( $value['output'] ) ) {
						$value['output'] = $value['typed'];
					}
					$value['typed'] = '';
				}
			} else {
				// Fix values that were incorrectly saved as strings
				if ( strpos( $value, '[{"lx":' ) !== false ) {
					$value = array( 'output' => $value );
				} else {
					$value = array( 'typed' => $value );
				}
			}
		}
	}

    /**
     * front_field function.
     *
     * called from FrmjQAutocomHooksController::load_hooks()
	 *
     * @access public
     * @static
     * @param array $field
     * @param mixed $field_name
     * @return void
     */
    public static function front_field( $field, $field_name ) {
        if ( ! self::array_find( 'jqautocom', $field ) ) {
            return;
        }

        if ( ! isset( $field['label1'] ) ) {
            $field_obj = FrmField::getOne( $field['id'] );

            foreach ( self::get_defaults() as $k => $v ) {
                if ( ! isset( $field[ $k ] ) ) {
                    $field[ $k ] = isset( $field_obj->field_options[ $k ] ) ? $field_obj->field_options[ $k ] : $v;
                }
            }

            unset($field_obj);
        }

        global $frm_editing_entry, $frm_vars;

        $entry_id = isset($frm_vars['editing_entry']) ? $frm_vars['editing_entry'] : $frm_editing_entry;
        if ( $entry_id ) {
            //make sure entry is for this form
            $entry = FrmEntry::getOne( (int) $entry_id );

            if ( ! $entry || $entry->form_id != $field['form_id'] ) {
                $entry_id = false;
            }
            unset($entry);
        }

        $jqautocom_type = $frm_vars['jqautocom_type'];
        self::enqueue_scripts( $jqautocom_type );

        $style_settings = self::get_style_settings( $field['form_id']  );

        $field['value'] = stripslashes_deep($field['value']);
        $html_id = FrmFieldsHelper::get_html_id($field);

        require(FrmjQAutocomAppHelper::plugin_path() .'/views/front_field.php');
    }

    /**
     * footer_js function.
     *
     * @access public
     * @static
     * @return void
     * applies jqautocom_custom_js filter - allows end user to create own js file.
     */
    public static function footer_js(){

        if ( is_admin() ) {
            return;
        }

        global $frm_vars;

        if ( ! is_array( $frm_vars ) || ! isset( $frm_vars['jqautocom_fields'] ) || empty( $frm_vars['jqautocom_fields'] ) ) {
            return;
        }

        $js_file_to_load = apply_filters('jqautocom_custom_js', FrmjQAutocomAppHelper::plugin_path() . '/views/jqautocom_footer_js.php' );
        if ( file_exists( $js_file_to_load ) ) {
            include( $js_file_to_load );
        }
    }

    /**
     * validate function.
     *
     * called from FrmjQAutocomHooksController::load_hooks()
	 *
     * @access public
     * @static
     * @param array $errors
     * @param object $field
     * @param array $value
     * @return $errors
     */
    public static function validate( $errors, $field, $value ) {
        if ( stripos($field->type, 'jqautocom') === false || $field->required != '1' || isset( $errors['field'. $field->id] ) ) {
            return $errors;
        }

        if ( empty( $value ) || ( empty( $value['output'] ) && empty( $value['typed'] ) ) ) {
            if ( method_exists( 'FrmProFieldsHelper', 'is_field_hidden' ) ) {
                $hidden = FrmProFieldsHelper::is_field_hidden( $field, $_POST );
            } else {
                $hidden = false;
            }

            if ( ! $hidden ) {
                global $frm_settings;
                $errors['field'. $field->id] = ( ! isset( $field->field_options['blank'] ) || empty( $field->field_options['blank'] ) ) ? $frm_settings->blank_msg : $field->field_options['blank'];
            }
        }

        return $errors;
    }

    //Add Single Option or Other Option
    public static function add_option() {
		FrmAppHelper::permission_check('frm_edit_forms');
        check_ajax_referer( 'frm_ajax', 'nonce' );

		$id = FrmAppHelper::get_post_param( 'field_id', 0, 'absint' );
		$opt_type = FrmAppHelper::get_post_param( 'opt_type', '', 'sanitize_text_field' );
		$opt_key = FrmAppHelper::get_post_param( 'opt_key', 0, 'absint' );

        $field = FrmField::getOne($id);

        if ( 'other' == $opt_type ) {
			$opt = __( 'Other', 'formidable' );
            $other_val = '';
            $opt_key = 'other_' . $opt_key;
        } else {
			$opt = __( 'New Option', 'formidable' );
        }
        $field_val = $opt;

        $field_data = $field;
		$field = (array) $field;
		$field['separate_value'] = isset( $field_data->field_options['separate_value'] ) ? $field_data->field_options['separate_value'] : 0;
		unset( $field_data );

		$field_name = 'item_meta[' . $id . ']';
		$html_id = FrmFieldsHelper::get_html_id( $field );
        $checked = '';

        if ( 'other' == $opt_type ) {
			include( FrmjQAutocomAppHelper::plugin_path() . '/views/other-option.php' );
        } else {
			require( FrmjQAutocomAppHelper::plugin_path() . '/views/single-option.php' );
        }
        wp_die();
    }

    public static function jqautocom_import_options() {
		FrmAppHelper::permission_check('frm_edit_forms');
        check_ajax_referer( 'frm_ajax', 'nonce' );

        if ( ! is_admin() || ! current_user_can('frm_edit_forms') ) {
            return;
        }

		$field_id = absint( $_POST['field_id'] );
        $field = FrmField::getOne($field_id);

		if ( stripos($field->type, 'jqautocom') === false  ) {
            return;
        }

        $field = FrmFieldsHelper::setup_edit_vars($field);
		$opts = FrmAppHelper::get_param( 'opts', '', 'post', 'wp_kses_post' );
		$opts = explode( "\n", rtrim( $opts, "\n" ) );
		$opts = array_map( 'trim', $opts );

        if ( $field['separate_value'] ) {
            foreach ( $opts as $opt_key => $opt ) {
                if ( strpos($opt, '|') !== false ) {
                    $vals = explode('|', $opt);
                    if ( $vals[0] != $vals[1] ) {
                        $opts[ $opt_key ] = array( 'label' => trim( $vals[0] ), 'value' => trim( $vals[1] ) );
                    }
                    unset($vals);
                }
                unset($opt_key, $opt);
            }
        }

        //Keep other options after bulk update
        if ( isset( $field['field_options']['other'] ) && $field['field_options']['other'] == true ) {
            $other_array = array();
            foreach ( $field['options'] as $opt_key => $opt ) {
				if ( FrmFieldsHelper::is_other_opt( $opt_key ) ) {
					$other_array[ $opt_key ] = $opt;
				}
                unset($opt_key, $opt);
            }
            if ( ! empty($other_array) ) {
                $opts = array_merge( $opts, $other_array);
            }
        }

        $field['options'] = $opts;

        self::show_single_option($field);

        wp_die();
    }

    public static function jqautocom_import_choices() {
        FrmAppHelper::permission_check( 'frm_edit_forms', 'hide' );

		$field_id = absint( $_REQUEST['field_id'] );

        global $current_screen, $hook_suffix;

        // Catch plugins that include admin-header.php before admin.php completes.
        if ( empty( $current_screen ) && function_exists( 'set_current_screen' ) ) {
            $hook_suffix = '';
        	set_current_screen();
        }

        if ( function_exists( 'register_admin_color_schemes' ) ) {
            register_admin_color_schemes();
        }

		$hook_suffix = '';
		$admin_body_class = '';

        if ( get_user_setting( 'mfold' ) == 'f' ) {
        	$admin_body_class .= ' folded';
        }

        if ( function_exists( 'is_admin_bar_showing' ) && is_admin_bar_showing() ) {
        	$admin_body_class .= ' admin-bar';
        }

        if ( is_rtl() ) {
        	$admin_body_class .= ' rtl';
        }

        $admin_body_class .= ' admin-color-' . sanitize_html_class( get_user_option( 'admin_color' ), 'fresh' );
        $prepop = array();
        FrmFieldsHelper::get_bulk_prefilled_opts($prepop);

        $field = FrmField::getOne($field_id);

        wp_enqueue_script( 'utils' );
		wp_enqueue_style( 'formidable-admin', FrmAppHelper::plugin_url() . '/css/frm_admin.css' );
        FrmjQAutocomAppHelper::load_jqautocom_admin_wide_js();

		include( FrmjQAutocomAppHelper::plugin_path() . '/views/import_choices.php' );
        wp_die();
    }

	public static function show_single_option( $field ) {
        $field_name = $field['name'];
        $html_id = FrmFieldsHelper::get_html_id($field);
        foreach ( $field['options'] as $opt_key => $opt ) {
            $field_val = apply_filters('frm_field_value_saved', $opt, $opt_key, $field);
            $opt = apply_filters('frm_field_label_seen', $opt, $opt_key, $field);

            // If this is an "Other" option, get the HTML for it
			if ( FrmFieldsHelper::is_other_opt( $opt_key ) ) {
                // Get string for Other text field, if needed
				$other_val = FrmFieldsHelper::get_other_val( compact( 'opt_key', 'field' ) );
				include( FrmjQAutocomAppHelper::plugin_path() . '/views/other-option.php' );
            } else {
				include( FrmjQAutocomAppHelper::plugin_path() . '/views/single-option.php' );
            }
        }
    }


    /**
     * include_updater function.
     *
     * called from FrmjQAutocomHooksController::load_admin_hooks()
	 *
     * @access public
     * @static
     * @return void
     */
    public static function include_updater(){
		if ( class_exists( 'FrmAddon' ) ) {
			include_once( FrmjQAutocomAppHelper::plugin_path() .'/models/FrmjQAutocomUpdate.php' );
			FrmjQAutocomUpdate::load_hooks();
		}
    }

    private static function process_choices( $choices ) {
        return $choices;
    }

    /**
     * get_style_settings function.
     *
     * called from self::setup_jqautocom_fields and self::front_field
     *
     * @access private
     * @static
     * @param mixed $form_id
     * @return $style_settings
     */
    private static function get_style_settings( $form_id ) {
        if ( is_callable( 'FrmStylesController::get_form_style' ) ) {
            $style_settings = FrmStylesController::get_form_style( $form_id );
            $style_settings = $style_settings->post_content;
        } else {
            global $frmpro_settings;
            if ( ! $frmpro_settings && class_exists('FrmProSettings') ) {
                $frmpro_settings = new FrmProSettings();
            }
            $style_settings = (array) $frmpro_settings;
        }
        return $style_settings;
    }
}