<?php
/*
Plugin Name: Formidable jQuery Autocomplete
Description: Use jQuery Autocomplete with Formidable Pro
Version: 1.0.0b2
Plugin URI: https://victorfont.com/plugins/formidable-jqautocom/
Author URI: https://victorfont.com/
Author: Victor M. Font Jr.
Text domain: frmjqautocom
Copyright 2017  Victor M. Font Jr.  (email : customer-service@victorfont.com)
*/

/**
 * frm_jqautocom_autoloader function.
 *
 * @access public
 * @param string $class_name
 * @return void
 */

function frm_jqautocom_autoloader( $class_name ) {

    $path = dirname(__FILE__);

	// Only load Frm classes here
	if ( ! preg_match('/^FrmjQAutocom.+$/', $class_name) ) {
		return;
	}

	if ( preg_match('/^.+Helper$/', $class_name) ) {
		$path .= '/helpers/' . $class_name . '.php';
	} else if ( preg_match('/^.+Controller$/', $class_name) ) {
		$path .= '/controllers/'. $class_name .'.php';
	} else {
		$path .= '/models/'. $class_name .'.php';
	}

	if ( file_exists($path) ) {
        require_once($path);
	}
}

// Add the autoloader
spl_autoload_register('frm_jqautocom_autoloader');

// Load hooks
FrmjQAutocomHooksController::load_hooks();




