<?php

class FrmjQAutocomAppHelper {

	/**
	 * plugin_folder function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function plugin_folder() {
		return basename( self::plugin_path() );
	}

	/**
	 * plugin_path function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function plugin_path() {
		return dirname( dirname( __FILE__ ) );
	}

	/**
	 * plugin_url function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
	public static function plugin_url() {
		return plugins_url( '', self::plugin_path() . '/formidable-jqautocom.php' );
	}

    public static function plugin_version() {
        return '1.0.0b2';
    }

	/**
	 * load_jqautocom_admin_wide_js function.
	 *
	 * @access public
	 * @static
	 * @return void
	 */
    public static function load_jqautocom_admin_wide_js( $load = true ) {
        $version = self::plugin_version();
		wp_register_script( 'jqautocom_admin_global', self::plugin_url() . '/js/jqautocom_admin_global.js', array( 'jquery' ), $version );

		if ( $load ) {
			wp_enqueue_script( 'jqautocom_admin_global' );
		}
    }

    /**
     * str_putcsv function.
     *
     * Generate CSV data from array
     *
     * @access public
     * @param mixed $data
     * @return void
     */
    public static function str_putcsv( $data ) {

        $csv = "";
        // write out the data
        foreach ( $data as $key => $value ) {
            if ( $key === 'jqautocom_options' && gettype($value) === 'array' ) {
                $csv = implode("','", $value);
            }
        }
        return "'" . $csv . "'";
    }

    /**
     * get_jqautocom_input_id function.
     *
     * @access public
     * @static
     * @param string $html_id
     * @return string
     */
    public static function get_jqautocomplete_input_id( $html_id ) {
        return $html_id . "_autocomplete";
    }

    public static function show_wp_filter() {
        global $wp_filter;
        d($wp_filter);
    }

	/**
	 * Checks if the site is in development/debug mode.
	 *
	 * @since 1.0.0
	 *
	 * @return bool
	 */
	public static function site_is_in_debug_mode() {
		if ( ! defined( 'SCRIPT_DEBUG' ) ) {
			return false;
		}
		return ( (bool) SCRIPT_DEBUG === true );
	}

}