<?php
    /* convert the options array to a string that can be used by the jQuery AutoComplete function */
    $availableTags = FrmjQAutocomAppHelper::str_putcsv( $frm_vars );
    $jqautocom_type = $frm_vars['jqautocom_type'];
    // $jqautocom_type = "jqautocom-combo";
    $html_id = $frm_vars['html_id'];
    $jqautocomplete_input = FrmjQAutocomAppHelper::get_jqautocomplete_input_id( $html_id );

?>
<script id="footer_js" type="text/javascript">
/*<![CDATA[*/
__FRMJQAUTOCOM=<?php  echo json_encode( (array) $frm_vars['jqautocom_fields'] ) ?>;
/*]]>*/
jQuery(document).ready(function ($) {
    "use strict";
<?php

    switch ($jqautocom_type) {

        case "jqautocom-categories":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-categories_footer_js.php' );
            break;

        case "jqautocom-combo":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-combo_footer_js.php' );
            break;

        case "jqautocom-custom":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-custom_footer_js.php' );
            break;

        case "jqautocom-scroll":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-scroll_footer_js.php' );
            break;

        case "jqautocom-accent":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-accent_footer_js.php' );
            break;

        case "jqautocom-multi":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-multi_footer_js.php' );
            break;

        case "jqautocom-multi-remote":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-multi-remote_footer_js.php' );
            break;

        case "jqautocom-remote":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-remote_footer_js.php' );
            break;

        case "jqautocom-jsonp":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-jsonp_footer_js.php' );
            break;

        case "jqautocom-remote-cache":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-remote-cache_footer_js.php' );
            break;

        case "jqautocom-xml":
            require( FrmjQAutocomAppHelper::plugin_path() . '/js/jqautocom-xml_footer_js.php' );
            break;

        default:

            if ( FrmjQAutocomAppHelper::site_is_in_debug_mode() ) {
?>
       $.widget("frmdefault.autocomplete", $.ui.autocomplete, {
            _create: function() {
                this.wrapper = $("<div>").addClass("ui-widget").insertAfter(this.element);
                this.element.hide();
                this._createAutocomplete();
            },
            _createAutocomplete: function() {
                var selected = this.element.children(":selected"),
                    value = selected.val() ? selected.text() : "";
                this.input = $("<input>").appendTo(this.wrapper).val(value).attr("id", "<?php echo esc_attr( $jqautocomplete_input ) ?>").attr("title", "").attr("type", "text").autocomplete({
                    delay: 0,
                    minLength: 0,
                    source: $.proxy(this, "_source")
                }).tooltip({
                    classes: {
                        "ui-tooltip": "ui-state-highlight"
                    }
                });
                this._on(this.input, {
                    autocompleteselect: function(event, ui) {
                        ui.item.option.selected = true;
                        this._trigger("select", event, {
                            item: ui.item.option
                        });
                    },
                    autocompletechange: "_removeIfInvalid"
                });
            },
            _source: function(request, response) {
                var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
                response(this.element.children("option").map(function() {
                    var text = $(this).text();
                    if (this.value && (!request.term || matcher.test(text))) return {
                        label: text,
                        value: text,
                        option: this
                    };
                }));
            },
            _removeIfInvalid: function(event, ui) {
                // Selected an item, nothing to do
                if (ui.item) {
                    return;
                }
                // Search for a match (case-insensitive)
                var value = this.input.val(),
                    valueLowerCase = value.toLowerCase(),
                    valid = false;
                this.element.children("option").each(function() {
                    if ($(this).text().toLowerCase() === valueLowerCase) {
                        this.selected = valid = true;
                        return false;
                    }
                });
                // Found a match, nothing to do
                if (valid) {
                    return;
                }
                // Remove invalid value
                this.input.val("").attr("title", value + " didn't match any item").tooltip("open");
                this.element.val("");
                this._delay(function() {
                    this.input.tooltip("close").attr("title", "");
                }, 2500);
                this.input.autocomplete("instance").term = "";
            },
            _destroy: function() {
                this.wrapper.remove();
                this.element.show();
            }
        });

    <?php

        } else {
    ?>
    $( function() {
        var availableTags = [<?php echo $availableTags ?>];
        $( "#<?php echo esc_attr( $jqautocomplete_input ) ?>" ).autocomplete({
            source: availableTags
        });
    });
    $("#<?php echo esc_attr( $jqautocomplete_input ) ?>").on('change', function() {
        $("#<?php echo esc_attr( $html_id ) ?>").val( $(this).val() );
    });

    $("#<?php echo esc_attr( $html_id ) ?>").autocomplete();

<?php
        }
    }
?>
});
</script>